using System;
using System.Collections.Generic;

public class DLParser
{ 
    private Dictionary<string, string> fieldValues = new Dictionary<string, string>();
    //private string metadata;

    public DLParser(string dlstring)
    {
        // Split a string into an array of strings
        string[] dlstringarray = dlstring.Split('\n');
        dlstringarray = dlstringarray[2..]; // Remove the first two lines

        for (int i = 0; i < dlstringarray.Length; i++)
        {
            dlstringarray[i] = dlstringarray[i].Trim();
        }

        // Removing 'ANSI' from the title
        //dlstringarray[0] = dlstringarray[0][5..];

        // Saving metadata
        // metadata = dlstringarray[0];

        // 
        List<string> fields = new List<string>(dlstringarray);
        //fields.RemoveAt(0);

        // Parsing field values
        foreach (var field in fields)
        {
            if (field == "")
                break;
            string fieldID = field.Substring(0, 3);
            string fieldValue = field.Substring(3);
            fieldValues[fieldID] = fieldValue;
        }
    }

     

    public string DCB()
    {
        return fieldValues.ContainsKey("DCB") ? fieldValues["DCB"] : "";
    }

    public string DAC()
    {
        return fieldValues.ContainsKey("DAC") ? fieldValues["DAC"] : "";
    }

    public string DAD()
    {
        return fieldValues.ContainsKey("DAD") ? fieldValues["DAD"] : "";
    }

    public string DCBInfo()
    {
        return "Jurisdiction specific restriction codes";
    }

    public string DCD()
    {
        return fieldValues.ContainsKey("DCD") ? fieldValues["DCD"] : "";
    }

    public string DCDInfo()
    {
        return "Jurisdiction specific endorsement codes";
    }

    public string DBA()
    {
        return fieldValues.ContainsKey("DBA") ? fieldValues["DBA"] : "";
    }

    public string DBAInfo()
    {
        return "Document Expiration date";
    }

    public string DCS()
    {
        return fieldValues.ContainsKey("DCS") ? fieldValues["DCS"] : "";
    }

    public string DCSInfo()
    {
        return "Customer Family Name";
    }

    public string DCT()
    {
        return fieldValues.ContainsKey("DCT") ? fieldValues["DCT"] : "";
    }

    public string DCTInfo()
    {
        return "Customer Given Name";
    }

    public string DBD()
    {
        return fieldValues.ContainsKey("DBD") ? fieldValues["DBD"] : "";
    }

    public string DBDInfo()
    {
        return "Document Issue Date";
    }

    public string DBB()
    {
        return fieldValues.ContainsKey("DBB") ? fieldValues["DBB"] : "";
    }

    public string DBBInfo()
    {
        return "Date of Birth";
    }

    public string DBC()
    {
        return fieldValues.ContainsKey("DBC") ? fieldValues["DBC"] : "";
    }

    public string DBCInfo()
    {
        return "Sex (1 for male, 2 for female)";
    }

    public string DAY()
    {
        return fieldValues.ContainsKey("DAY") ? fieldValues["DAY"] : "";
    }

    public string DAYInfo()
    {
        return "Eye Color";
    }

    public string DAU()
    {
        return fieldValues.ContainsKey("DAU") ? fieldValues["DAU"] : "";
    }

    public string DAUInfo()
    {
        return "Height";
    }

    public string DAG()
    {
        return fieldValues.ContainsKey("DAG") ? fieldValues["DAG"] : "";
    }

    public string DAGInfo()
    {
        return "Address Line 1";
    }

    public string DAI()
    {
        return fieldValues.ContainsKey("DAI") ? fieldValues["DAI"] : "";
    }

    public string DAIInfo()
    {
        return "City";
    }

    public string DAJ()
    {
        return fieldValues.ContainsKey("DAJ") ? fieldValues["DAJ"] : "";
    }

    public string DAJInfo()
    {
        return "State";
    }

    public string DAK()
    {
        return fieldValues.ContainsKey("DAK") ? fieldValues["DAK"] : "";
    }

    public string DAKInfo()
    {
        return "Postal Code";
    }

    public string DAQ()
    {
        return fieldValues.ContainsKey("DAQ") ? fieldValues["DAQ"] : "";
    }

    public string DAQInfo()
    {
        return "Customer ID Number";
    }

    public string DCF()
    {
        return fieldValues.ContainsKey("DCF") ? fieldValues["DCF"] : "";
    }

    public string DCFInfo()
    {
        return "Document Discriminator";
    }

    public string DCG()
    {
        return fieldValues.ContainsKey("DCG") ? fieldValues["DCG"] : "";
    }

    public string DCGInfo()
    {
        return "Country Identification";
    }

    public string DCK()
    {
        return fieldValues.ContainsKey("DCK") ? fieldValues["DCK"] : "";
    }

    public string DCKInfo()
    {
        return "Inventory control number";
    }

}




